function [ cp ] = prdspl_3( Mrd1d2d3,c1,c2,c3 )
%Find coeff of prod spline in S^r_{d1+d2+d3} of splines in S^r_{d1,d2,d3}
%   c1,c2,c3 represent three splines in S^{r}_{d1}(orig_delta),S^{r}_{d2}(orig_delta)
%   S^{r}_{d3}(orig_delta) respectively.  Mrd1d2d3 is the output of
%   prdspl_aux_3. The output cp is row vector of coefficients for the
%   B-spline basis.

%(c1d1N1d1+...+cn1d1Nn1d1)*(c1d2N1d2+...+cn2d2Nn2d2)*(c1d3N1d3+...+cn3d2Nn2d2) = 
%\sum (cid1*cjd2*ckd3)*(Nid1*Njd2*Nkd3)

n1 = size(c1,2);
n2 = size(c2,2);
n3 = size(c3,3);
np = size(Mrd1d2d3,4);

cp = zeros(1,np);

storage = zeros(1,1,1,np); %Intermediary storage because want final answer to
                         %be a row vector.
                       
for i=1:n1
    for j=1:n2
        for k=1:n3
            storage = storage + c1(1,i)*c2(1,j)*c3(1,k)*Mrd1d2d3(i,j,k,:);
        end
    end
end

for i=1:np
    cp(1,i) = storage(1,1,1,i);
end


end

